@extends('layouts.app')

@section('content')
    <!-- Page Header -->
    <div class="py-8 sm:py-12 md:py-16 bg-gray-50">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="text-center">
                <h1 class="text-2xl sm:text-3xl md:text-4xl font-bold text-gray-900 mb-4">Cari Hasil MCU Karyawan</h1>
                <p class="text-lg sm:text-xl text-gray-600">Cari hasil MCU Anda dengan nomor karyawan dan tanggal lahir</p>
            </div>
        </div>
    </div>

    <!-- Main Content -->
    <div class="py-8 sm:py-12 md:py-16 bg-white">
        <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="bg-white overflow-hidden shadow-sm sm:rounded-none">
                <div class="p-6 text-gray-900">
                    @if (!isset($employee))
                        <!-- Form Pencarian -->
                        <div class="max-w-md mx-auto">
                            <div class="text-center mb-8">
                                <div
                                    class="w-16 h-16 bg-[#192D50] rounded-full flex items-center justify-center mx-auto mb-4">
                                    <svg class="w-8 h-8 text-white" fill="none" stroke="currentColor"
                                        viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"></path>
                                    </svg>
                                </div>
                                <h3 class="text-xl sm:text-2xl font-bold text-gray-900 mb-2">Cari Hasil MCU</h3>
                                <p class="text-gray-600">Masukkan nomor karyawan dan tanggal lahir untuk melihat hasil MCU
                                    Anda.</p>
                            </div>

                            <form method="POST" action="{{ route('mcu.employee.lookup') }}" class="space-y-6">
                                @csrf

                                <div>
                                    <label for="employee_no" class="block text-sm font-medium text-gray-700 mb-2">No.
                                        Karyawan</label>
                                    <input type="text" id="employee_no" name="employee_no"
                                        value="{{ old('employee_no') }}" required autofocus
                                        class="w-full px-4 py-3 border border-gray-300 rounded-none focus:ring-2 focus:ring-[#CBB4B0] focus:border-[#CBB4B0]">
                                    @error('employee_no')
                                        <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                                    @enderror
                                </div>

                                <div>
                                    <label for="birth_date" class="block text-sm font-medium text-gray-700 mb-2">Tanggal
                                        Lahir</label>
                                    <input type="date" id="birth_date" name="birth_date" value="{{ old('birth_date') }}"
                                        required
                                        class="w-full px-4 py-3 border border-gray-300 rounded-none focus:ring-2 focus:ring-[#CBB4B0] focus:border-[#CBB4B0]">
                                    @error('birth_date')
                                        <p class="text-red-500 text-sm mt-1">{{ $message }}</p>
                                    @enderror
                                </div>

                                <div class="flex items-center justify-end">
                                    <button type="submit"
                                        class="bg-[#192D50] text-white px-6 py-3 rounded-none font-semibold">
                                        Cari
                                    </button>
                                </div>
                            </form>
                        </div>
                    @else
                        <!-- Hasil Pencarian -->
                        <div class="mb-6">
                            <h3 class="text-xl sm:text-2xl font-bold text-gray-900 mb-4">Hasil MCU - {{ $employee->name }}</h3>
                            <div class="bg-gray-50 p-4 rounded-none">
                                <div class="grid grid-cols-1 md:grid-cols-2 gap-4 text-sm">
                                    <div>
                                        <p class="font-medium text-gray-900">No. Karyawan:</p>
                                        <p class="text-gray-600">{{ $employee->employee_number }}</p>
                                    </div>
                                    <div>
                                        <p class="font-medium text-gray-900">Posisi:</p>
                                        <p class="text-gray-600">{{ $employee->position }}</p>
                                    </div>
                                    <div>
                                        <p class="font-medium text-gray-900">Departemen:</p>
                                        <p class="text-gray-600">{{ $employee->department }}</p>
                                    </div>
                                    <div>
                                        <p class="font-medium text-gray-900">Perusahaan:</p>
                                        <p class="text-gray-600">{{ $employee->company->name }}</p>
                                    </div>
                                </div>
                            </div>
                        </div>

                        @if ($allResults->count() > 0)
                            <div class="space-y-4">
                                @foreach ($allResults as $result)
                                    <div class="bg-gray-50 p-4 rounded-none">
                                        <div class="flex justify-between items-start">
                                            <div>
                                                <h4 class="font-medium text-gray-900">
                                                    {{ ucfirst($result->examResult->exam_type ?? 'MCU') }}</h4>
                                                <p class="text-sm text-gray-600">
                                                    Tanggal: {{ $result->exam_date->format('d/m/Y') }}
                                                </p>
                                                @if ($result->notes)
                                                    <p class="text-sm text-gray-600 mt-1">{{ $result->notes }}</p>
                                                @endif
                                            </div>
                                            <div class="flex items-center space-x-2">
                                                <span
                                                    class="inline-flex items-center px-2.5 py-0.5 rounded-full text-xs font-medium
                                                    @if ($result->status == 'completed') bg-green-100 text-green-800
                                                    @elseif($result->status == 'pending') bg-yellow-100 text-yellow-800
                                                    @else bg-red-100 text-red-800 @endif">
                                                    {{ ucfirst($result->status) }}
                                                </span>
                                                @if ($result->result_file_path)
                                                    <a href="{{ route('mcu.file.view', ['resultId' => $result->id, 'type' => isset($result->is_direct) ? 'exam' : 'employee']) }}"
                                                        target="_blank"
                                                        class="inline-flex items-center px-3 py-1 border border-transparent text-xs font-medium rounded text-[#CBB4B0] bg-white hover:bg-[#192D50] hover:text-white transition duration-150">
                                                        <svg class="w-4 h-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path>
                                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"></path>
                                                        </svg>
                                                        Preview
                                                    </a>
                                                    <a href="{{ route('mcu.file.download', ['resultId' => $result->id, 'type' => isset($result->is_direct) ? 'exam' : 'employee']) }}"
                                                        class="inline-flex items-center px-3 py-1 border border-transparent text-xs font-medium rounded text-white bg-[#192D50] hover:bg-[#8B8B8B] transition duration-150">
                                                        <svg class="w-4 h-4 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 10v6m0 0l-3-3m3 3l3-3m2 8H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                                                        </svg>
                                                        Download
                                                    </a>
                                                @endif
                                            </div>
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                        @else
                            <div class="text-center py-8">
                                <div class="mx-auto flex items-center justify-center h-12 w-12 rounded-full bg-gray-100">
                                    <svg class="h-6 w-6 text-gray-400" fill="none" stroke="currentColor"
                                        viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                            d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z">
                                        </path>
                                    </svg>
                                </div>
                                <h3 class="mt-4 text-lg font-medium text-gray-900">Belum Ada Hasil MCU</h3>
                                <p class="mt-2 text-sm text-gray-600">
                                    Belum ada hasil MCU yang tersedia untuk karyawan ini.
                                    Silakan cek kembali nanti atau hubungi HRD perusahaan.
                                </p>
                            </div>
                        @endif

                        <div class="mt-6 text-center">
                            <a href="{{ route('mcu.employee.lookup.form') }}"
                                class="inline-flex items-center px-4 py-2 border border-gray-300 text-sm font-medium rounded-none text-gray-700 bg-white hover:bg-gray-50">
                                Cari Karyawan Lain
                            </a>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
@endsection
